program sample2;

{-------------------------------------------------------}
{ DR. JOHANNES HEIDENHAIN GmbH, Traunreut, Germany      }
{                                                       }
{ Interrupt Test                                        }
{                                                       }
{ V 1.00                                                }
{ July 1994                                             }
{-------------------------------------------------------}
{ IRQ12 for Int1                                        }
{ IRQ15 for Int0                                        }
{ Interrupt jumpers must be plugged in!                 }
{ The interrupts are triggered by a falling edge        }
{ at the L0 or L1 input                                 }
{-------------------------------------------------------}

{$N+,E+}
{$V+}
{$R+}

uses crt,dos,ik121_0,ik121_1;

var
  board                   : ik121_pointr;
  axis1,axis2             : g26_pointr;
  oldvec,newvec,ovec,nvec : pointer;

(*________________________________________*)
procedure hardlatch1;interrupt;
begin
    Read_int_Status(board^.axis[1]);
    read_reg0(board^.axis[1]);
    read_reg0(board^.axis[2]);
    gotoxy(1,20);
    textcolor(4);
    writeln(' Axis1 - Register0:  ',board^.axis[1]^.register0:10:0,'       ');
    gotoxy(1,21);
    writeln(' Axis2 - Register0:  ',board^.axis[2]^.register0:10:0,'       ');
    textcolor(15);
    Clear_int;
end;
(*________________________________________*)
procedure hardlatch2;interrupt;
begin
    Read_int_Status(board^.axis[2]);
    read_reg1(board^.axis[2]);
    gotoxy(1,15);
    textcolor(1);
    writeln(' Axis2 - Register1:  ',board^.axis[2]^.register1:10:0,'       ');
    textcolor(15);
    Clear_int;
end;
(*________________________________________*)
procedure main;
begin
  (* Axis 1 *)

  board^.axis[1]^.inimain.mode1024:=true;
  board^.axis[1]^.inimain.en_timer:=true;
  board^.axis[1]^.softcomm.clear:=true;
  board^.axis[1]^.softcomm.start:=true;
  board^.axis[1]^.timer:=$8000;
  board^.axis[1]^.inilatch.en_timer_reg1:=true;   (* Reg1 timer *)
  board^.axis[1]^.inilatch.en_l0_reg0:=true;      (* Reg0 external *)
  board^.axis[1]^.inisync.en_l0_axis2:=true;      (* Cascade to axis 2 *)

  (* Axis 2 *)

  board^.axis[2]^.inimain.mode1024:=true;
  board^.axis[2]^.softcomm.clear:=true;
  board^.axis[2]^.softcomm.start:=true;
  board^.axis[2]^.inilatch.en_l0_reg0:=true;    (* L0 from axis 1 *)
  board^.axis[2]^.inilatch.en_l1_reg1:=true;    (* L1 external *)

  Init_Handler(board^.axis[1]);
  Init_Handler(board^.axis[2]);
  Comm_Handler(board^.axis[1]);
  Comm_Handler(board^.axis[2]);

  board^.axis[1]^.iniint.reg0:=true;
  Init_Handler(board^.axis[1]);

  board^.axis[2]^.iniint.reg1:=true;
  Init_Handler(board^.axis[2]);

  getintvec(IRQ15,oldvec);
  newvec:=@hardlatch1;
  setintvec(IRQ15,newvec);
  Read_int_Status(board^.axis[1]);
  read_reg0(board^.axis[1]);
  read_reg0(board^.axis[2]);

  getintvec(IRQ12,ovec);
  nvec:=@hardlatch2;
  setintvec(IRQ12,nvec);
  Read_int_Status(board^.axis[2]);
  read_reg1(board^.axis[2]);

  Clear_int;
  En_int(IRQ15);
  En_int(IRQ12);

  gotoxy(40,22);
  writeln('Press any key !');

  repeat
    Read_Reg1(board^.axis[1]);
    Dis_Int(IRQ15);
    Dis_Int(IRQ12);
    gotoxy(1,10);
    writeln(' Axis1 - Register1:  ',board^.axis[1]^.register1:10:0,'       ');
    En_Int(IRQ15);
    En_Int(IRQ12);
  until keypressed;

  Read_int_Status(board^.axis[1]);
  Read_int_Status(board^.axis[2]);
  Dis_Int(IRQ15);
  Dis_Int(IRQ12);

  setintvec(IRQ15,oldvec);
  setintvec(IRQ12,ovec);
end;
(*________________________________________*)
begin
  textbackground(7);
  clrscr;
  textcolor(15);
  New(board);
  New(axis1);
  New(axis2);
  board^.axis[1]:=axis1;
  board^.axis[2]:=axis2;
  init_ik121(board);
  if look_for_ik121(board) then
    begin
      main
    end
  else
    begin
      clrscr;
      write('No hardware!!');
      readln;
    end;
  Dispose(board);
  Dispose(axis1);
  Dispose(axis2);
  textbackground(0);
  clrscr;
end.
(*________________________________________*)